#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "initial_setting.h"
#include "gw64_adc.h"


/*High level Applications for ADC*/
void ADC_SortAscendingData(unsigned int *arr, unsigned char no_of_values);
unsigned int ADC_AverageData(unsigned char,unsigned char,
                             unsigned int* , unsigned char); 
void ADC0_SW_Trig_Single_Channel_Read(void);
void ADC0_SW_Trig_Diff_Channel_Read(void);
void ADC1_SW_Trig_Single_Channel_Read(void);
void ADC1_SW_Trig_Diff_Channel_Read(void); 
unsigned int data_AD2;
unsigned int data_AD3;

void main(void) {
  

  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */
  
  /*Configure the clock settings*/ 
  InitConfig();
  
  /*Enables the FCD for pins muxed with LCD*/         
  fcd_enable_on_lcd_pins(); 
  
  /*Initializes the ADC0 with bus clock as ADC clock,divide factor 1,12 bit conversion, enables software trigger, single conversion mode & external reference for ADC0 */ 
  ADC_Init(ADC_0,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
  
  /*Initializes the ADC1 with bus clock as ADC clock,divide factor 1,12 bit conversion, enables software trigger, single conversion mode & external reference for ADC1 */ 
  ADC_Init(ADC_1,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
  
  /*calibrates the ADC0*/
  ADC_Cal(ADC_0);
  
  /*calibrates the ADC1*/
  ADC_Cal(ADC_1);
  
  /*selects the channel AD2 channelA for conversion*/
  //ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD2); 
  ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD13);
  
  /*reads back and stores the data from channel AD2 in variable data_AD2*/
  Read_ADC0_A(&data_AD2);
 
  /*selects the channel AD2 channelA for conversion*/
  //ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD3); 
  ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD14);
  
  /*reads back and stores the data from channel AD2 in variable data_AD2*/
  Read_ADC1_A(&data_AD3);
  
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}


/*High Level Applications for ADC*/

/* read ADC2 single ended Channel when software trigger is enabled*/
void ADC0_SW_Trig_Single_Channel_Read()
{
   static float Analog_Data_1;
   ADC_Init(ADC_0,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
   ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD2);
   Analog_Data_1 = Read_ADC0_A_AnalogValue();
}

/*read ADC0 differential channel when Software trigger is enabled*/
void ADC0_SW_Trig_Diff_Channel_Read() 
{
  static float Analog_Data_2;
  ADC_Init(ADC_0,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
  ADC_Channel_Config(ADC_0,ADC_CHANNEL_A,ADC_AIEN_OFF,ADC_DIFF_MODE);
  ADC_Diff_Channel_Select(ADC_0,ADC_CHANNEL_A);
  Analog_Data_2 = Read_ADC0_A_AnalogValue();
}

/* read ADC3 single ended Channel when software trigger is enabled*/
void ADC1_SW_Trig_Single_Channel_Read()
{
   static float Analog_Data_3;
   ADC_Init(ADC_1,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
   ADC_Single_Channel_Select(ADC_CHANNEL_A,ADC_CHANNEL_AD3);
   Analog_Data_3 = Read_ADC1_A_AnalogValue();
}

/*read ADC1 differential channel when Software trigger is enabled*/
void ADC1_SW_Trig_Diff_Channel_Read() 
{
  static float Analog_Data_4;
  ADC_Init(ADC_1,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
  ADC_Channel_Config(ADC_1,ADC_CHANNEL_A,ADC_AIEN_OFF,ADC_DIFF_MODE);
  ADC_Diff_Channel_Select(ADC_1,ADC_CHANNEL_A);
  Analog_Data_4 = Read_ADC1_A_AnalogValue();
}



/* Binary Sorting*/
void ADC_SortAscendingData(unsigned int *arr, unsigned char no_of_values)
{
  unsigned int i, j;
  
  for(i = 0; i < no_of_values; i++)
  {
    for(j = i+1; j < no_of_values; j++)
    {
      if(arr[j] < arr[i])
      {
        unsigned int temp = arr[j];
        arr[j] = arr[i];
        arr[i] = temp;
      }
    }
  }
}

/*used to average the ADC data for a given no of times*/ 
unsigned int ADC_AverageData(unsigned char Channel_Index,unsigned char Channel,
                             unsigned int* arr, unsigned char no_of_values)
{
  unsigned char count = 0;
  unsigned int sum = 0;
 
 
  switch(Channel) 
      {
        case ADC_CHANNEL_AD0:
        case ADC_CHANNEL_AD2:
        case ADC_CHANNEL_AD4:
        case ADC_CHANNEL_AD5:
        case ADC_CHANNEL_AD8:
        case ADC_CHANNEL_AD9:
        case ADC_CHANNEL_AD12:
        case ADC_CHANNEL_AD13: 
                {
                  if(Channel_Index == ADC_CHANNEL_A)
                      while(count < no_of_values) 
                      {
                        ADC_Single_Channel_Select(Channel_Index,Channel);
                        Read_ADC0_A(&arr[count]);
                        count++;
                      }
                  else 
                      while(count < no_of_values) 
                      {
                        ADC_Single_Channel_Select(Channel_Index,Channel);
                        Read_ADC0_B(&arr[count]);
                        count++;
                      }
   
                  break;
                }
 
        case ADC_CHANNEL_AD1:
        case ADC_CHANNEL_AD3:
        case ADC_CHANNEL_AD6:
        case ADC_CHANNEL_AD7:
        case ADC_CHANNEL_AD10:
        case ADC_CHANNEL_AD11:
        case ADC_CHANNEL_AD14:
        case ADC_CHANNEL_AD15:
                 {
                    if(Channel_Index == ADC_CHANNEL_A)
                        while(count < no_of_values) 
                         {
                          ADC_Single_Channel_Select(Channel_Index,Channel);
                          Read_ADC1_A(&arr[count]);
                          count++;
                         }
                    else 
                        while(count < no_of_values) 
                         {
                          ADC_Single_Channel_Select(Channel_Index,Channel);
                          Read_ADC1_B(&arr[count]);
                          count++;
                         }
                    break;
                 }
      }
  
  //Binary sort
  ADC_SortAscendingData(arr, no_of_values);

  count = 2;
  while(count < no_of_values-2)
  {
    sum += arr[count++];
  }
  sum /= no_of_values-4;

  return sum;
}
